/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.pillar;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;

public final class FenceSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Direction adjDir;
        boolean sameBlock;
        boolean bl = sameBlock = adjState.m_60734_() == state.m_60734_();
        if (Utils.isY(side)) {
            if (sameBlock || FenceSkipPredicate.isVerticalPostOrLattice(adjState)) {
                return SideSkipPredicate.compareState(level, pos, side, state, adjState);
            }
            return false;
        }
        if (!FenceSkipPredicate.hasFenceArm(state, side)) {
            return false;
        }
        if (sameBlock && FenceSkipPredicate.hasFenceArm(adjState, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (adjState.m_60734_() == FBContent.blockFramedFenceGate.get() && ((adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_)).m_122428_() == side || adjDir.m_122427_() == side)) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean isVerticalPostOrLattice(BlockState state) {
        Block block = state.m_60734_();
        if (block == FBContent.blockFramedLattice.get()) {
            return (Boolean)state.m_61143_((Property)FramedProperties.Y_AXIS);
        }
        if (block == FBContent.blockFramedPost.get()) {
            return state.m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.Y;
        }
        return false;
    }

    private static boolean hasFenceArm(BlockState state, Direction side) {
        return switch (side) {
            case Direction.NORTH -> (Boolean)state.m_61143_((Property)FenceBlock.f_52309_);
            case Direction.EAST -> (Boolean)state.m_61143_((Property)FenceBlock.f_52310_);
            case Direction.SOUTH -> (Boolean)state.m_61143_((Property)FenceBlock.f_52311_);
            case Direction.WEST -> (Boolean)state.m_61143_((Property)FenceBlock.f_52312_);
            default -> throw new IllegalArgumentException("Invalid fence arm side: " + side);
        };
    }
}

